using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace FS28BluetoothSlaveModeDemo
{
    public partial class FormDbFolder : Form
    {
        public FormDbFolder()
        {
            InitializeComponent();
        }

        public string DbFolderName
        {
            get { return textDbFolder.Text; }
        }

        private void FormDbFolder_Load(object sender, EventArgs e)
        {
            string[] subdirectoryEntries = Directory.GetDirectories(Directory.GetCurrentDirectory());
            string folderName;
            foreach (string subdirectory in subdirectoryEntries)
            {
                int nIndex = subdirectory.LastIndexOf("\\");
                folderName = subdirectory.Substring(nIndex+1);
                listDbFolder.Items.Add(folderName);
            }
            textDbFolder.Text = "";
        }

        private void listDbFolder_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (listDbFolder.SelectedIndex != -1)
            {
                textDbFolder.Text = listDbFolder.SelectedItem.ToString();
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            if (textDbFolder.Text.Length == 0)
            {
                MessageBox.Show("Please input a folder name to save the templates!", "DB Folder", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }
            string strDbFolder = Path.Combine(Directory.GetCurrentDirectory(), textDbFolder.Text);
            if (!Directory.Exists(strDbFolder))
                Directory.CreateDirectory(strDbFolder);

            this.btnOK.DialogResult = DialogResult.OK;
            this.DialogResult = DialogResult.OK;
            this.Close();
        }
    }
}